<?php
    #namespace Dropbox;
    
    /*use Dropbox\Auth;
    use Dropbox\Files;
    use Dropbox\FileProperties;
    use Dropbox\FileRequests;
    use Dropbox\Paper;
    use Dropbox\Misc;
    use Dropbox\Sharing;
    use Dropbox\Users;*/

    /** DROPBOX root directory */
    if (!defined('DROPBOX_ROOT')) {
        define('DROPBOX_ROOT', dirname(__FILE__) . '/');

        require(DROPBOX_ROOT . 'Users.php');
        require(DROPBOX_ROOT . 'Files.php');
    }

    class Dropbox {
        private static $token;
        public $auth;
        public $files;
        public $file_properties;
        public $file_requests;
        public $paper;
        public $misc;
        public $sharing;
        public $users;
        
        public function __construct($accesstoken = null) {
            self::$token = $accesstoken;
            $this->files = new Files();
            $this->users = new Users();
        }
        
        /*
        * Main function for handling post requests.
        */
        public static function postRequest($endpoint, $headers, $data, $json = TRUE) {
            $ch = curl_init($endpoint);
            array_push($headers, "Authorization: Bearer " . self::$token);
            curl_setopt($ch, CURLOPT_POST, TRUE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            $r = curl_exec($ch);
            curl_close($ch);
            if ($json)
                return json_decode($r, true);
            else
                return $r;
        }
        
        /*
        * Special case function for handling the from_oauth1 request
        */
        public static function oauth1Request($endpoint, $data, $app_key, $app_secret) {
            $ch = curl_init($endpoint);
            $headers = array("Content-Type: application/json");
            curl_setopt($ch, CURLOPT_POST, TRUE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_USERPWD, "$app_key:$app_secret");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            $r = curl_exec($ch);
            curl_close($ch);
            return json_decode($r, true);
        }
        
        /*
        * Updates the access token.
        */
        public function updateAccessToken($accesstoken) {
            self::$token = $accesstoken;
        }
    }

?>