jQuery(document).ready(function () {
    //Common Form Validation
    
    if (jQuery().validate) {
	    var common_validator = jQuery('.common-frm-validation').validate({
	        errorElement 	: 'span',
	        errorClass 		: 'help-block help-block-error',
	        focusInvalid  	: false,
	        ignore 			: "",
	        errorPlacement: function(error, element) {
	            if (element.attr('type') === 'radio' || element.attr('type') === 'checkbox') {
	                jQuery(element).parents().find('.radio-checkbox-error').removeClass('hide');
	                jQuery(element).parents().find('.radio-checkbox-error').show();
	                jQuery(element).parents().find('.radio-checkbox-error').html(error);
	            } else {
	                if(jQuery(element).parents('.input-group').length == 1){
	                    error.insertAfter(element.parents('.input-group'));
	                } else {
	                    error.insertAfter(element);    
	                }
	            }
	        },
	        highlight: function (element) {
	        	jQuery(element).closest('.form-group').addClass('has-error');
	        },
	        unhighlight: function (element) {
	            jQuery(element).closest('.form-group').removeClass('has-error');
	        },
	        success: function (label) {
	            label.closest('.form-group').removeClass('has-error');
	        }
	    });
	}
	
	//universal ajax submit function
	jQuery(document).on('click', '.ajax-submit', function (e) {
		e.preventDefault();
		e.stopPropagation();

		var submit_btn 		= jQuery(this);
		var btn_name 		= jQuery(this).html();
		var new_btn_name 	= 'Loading...'
		var form 			= jQuery(this).parents('form:first');
		var method 			= jQuery(form).attr('method');
		var url 			= jQuery(form).attr('action');

		var valid = true;
        $('.required', form).each(function(i, v){
            valid = common_validator.element(v) && valid;

            if(valid == false){
                jQuery(v).parents('.form-group').addClass('has-error');
            } else {
                jQuery(v).parents('.form-group').removeClass('has-error');
            }
        });

        $('.max-validation', form).each(function(i, v){
            valid = common_validator.element(v) && valid;

            if(valid == false){
                jQuery(v).parents('.form-group').addClass('has-error');
            } else {
                jQuery(v).parents('.form-group').removeClass('has-error');
            }
        });

        if(!valid){
            return;
        }
		
		jQuery(form).ajaxSubmit({
			type: method,
			url: url,
			dataType : 'JSON',
			beforeSend : function() {
				jQuery(submit_btn).html(new_btn_name);
				jQuery(submit_btn).attr('disabled', true);
				jQuery(form).find('.form-group').removeClass('has-error');
				jQuery(form).find('span.help-block').remove();
			},
			success : function(data) {
				if(data.response == 1){
					jQuery(submit_btn).attr('disabled', true);

					if( data.alert == undefined || data.alert == 1 ) {
						swal({   
							title: "Done",   
							text: data.msg,   
							type: "success", 
							showCancelButton: false,
						    confirmButtonColor: "#DD6B55",
						    confirmButtonText: "OK",
						}, 
						function(){
							if(data.redirect){
								location.replace(data.redirect);
							} else {
								location.reload();	
							}
						});
					} else {
						if(data.redirect){
							location.replace(data.redirect);
						} else {
							location.reload();	
						}
					}
				} else if (data.response == 2){
					sweetAlert("Oops...", data.msg, "error");
				} else if (data.response == 3){
					swal({   
						title: "Hello...",   
						text: data.msg,   
						type: "info", 
						showConfirmButton: false,
                        timer: 900,
					}, 
					function(){   
						if(data.redirect){
							location.replace(data.redirect);
						} else if(data.reload){
							location.reload();	
						}
					});
				}
			},
			error : function (data) {
			    jQuery.each(data.responseJSON, function (key, index) {
			    	if(~key.indexOf(".")){
				        key = key.replace(/\./gi, '-');
				        jQuery('#'+key).closest('.form-group').addClass('has-error').append('<span class="help-block">'+index[0]+'</span>');
			    	} else {
			    		var input = jQuery(form).find('[name="'+key+'"]');
				        input.closest('.form-group').addClass('has-error').append('<span class="help-block">'+index[0]+'</span>');
			    	}
			    });
			},
			complete : function(){
				jQuery(submit_btn).html(btn_name);
				jQuery(submit_btn).attr('disabled', false);
			}
		});
	});

	//front-navbar
	var current_url= window.location.href;
	jQuery('.sidebar').find('a').each(function(){
		if(current_url == jQuery(this).attr('href')){
			jQuery(this).parents('li').addClass('active');
		}
	});

    //Date picker
	//Date picker
	if (jQuery().datepicker) {
	    $('.date-picker').datepicker({
	        orientation     : "center",
	        todayHighlight  : true,
	        todayBtn        :  1,
	        autoclose       : true,
			format: 'dd-mm-yyyy',
	    });
	}

	// radio

	$('input').iCheck({
       checkboxClass: 'icheckbox_flat',
       radioClass: 'iradio_flat'
    });

    jQuery(document).on('ifChecked', '#header-checkbox', function(event){
    	jQuery('.hide-header-blank').removeClass('hidden-print');
        jQuery('.hide-header-blank').show();
        jQuery('.show-header-blank').addClass('clickable');
        jQuery('.show-header-blank').hide();
    });

    jQuery(document).on('ifUnchecked', '#header-checkbox', function(event){
        jQuery('.hide-header-blank').addClass('hidden-print');
        jQuery('.hide-header-blank').hide();
        jQuery('.show-header-blank').show();
        jQuery('.show-header-blank').removeClass('clickable');
    });

});

function showNotification(heading, text, theme, life, pos_hor, pos_ver){

    life    = typeof life    !==  'undefined' ? life     : 2000;
    theme   = typeof theme   !==  'undefined' ? theme    : 'success';
    pos_hor = typeof pos_hor !==  'undefined' ? pos_hor  : 'bottom';
    pos_ver = typeof pos_ver !==  'undefined' ? pos_ver  : 'right';

    toastr.options = {
        "success" : 'error',
        "closeButton": true,
        "debug": false,
        "positionClass": 'toast-' + pos_hor + '-' + pos_ver,
        "onclick": null,
        "showDuration": "2000",
        "hideDuration": "2000",
        "timeOut": life,
        "extendedTimeOut": "2000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
    };

    if(theme == 'info') {
        toastr.info(text, heading);
    } else if(theme == 'error') {
        toastr.error(text, heading);
    } else {
        toastr.success(text, heading);
    }
}