<?php 
  if( !hasPermission($_SESSION['user_detail']['role_id'], 'bank_receipt_list') ) {
    echo '<script>window.location.href="index.php?page=no_permission.php"</script>';
    die();
  }
?> 
<section class="content-header">
  <div class="row">
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 bottom20">
        <h3 class="capital font15 padding5 bold">VIEW BANK RECEIPT DETAILS</h3>
      </div>
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 text-right bottom20">
        <h3>
          <?php if( hasPermission($_SESSION['user_detail']['role_id'], 'bank_receipt_add') ) { ?>
          <a href="index.php?page=bank_receipt/add.php" class="btn btn-danger capital bottom10 custome-btn">Add New BANK RECEIPT</a>
        <?php } ?>
        </h3>
      </div>
  </div>
</section>
<hr class="bottom35"> 
<section class="hitz-top-header">
  <div class="card bottom40">
    <div class="card-body table-responsive">
      <table id="example1" class="table table-bordered table-striped list_data width100">
        <thead>
          <tr>
            <th width="40">SR NO.</th>
            <th width="100">VOUCHER NO</th>
            <th width="100">DATE</th>
            <th width="150">BANK</th>
            <th>ACCOUNT NAME</th>
            <th width="100">TOTAL AMOUNT</th>
            <th width="100">CREATED BY</th>
            <th width="120">ACTION</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td colspan="8" align="text-center"><?php echo "NO RECORD FOUND"; ?></td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
</section>
<div id="dataModal" class="modal fade">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
       <div class="modal-body" id="employee_detail"></div>
       <div class="modal-footer hidden-print">  
          <button type="button" onclick="window.print();" class="btn btn-default">PRINT</button> 
          <button type="button" class="btn btn-default" data-dismiss="modal">CLOSE</button>  
       </div>
    </div>
  </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() {
      loadDataTable();
    });
    
    function loadDataTable(){
        if(typeof dTable!='undefined'){dTable.fnDestroy();}
    
        dTable=jQuery('.list_data').dataTable({
            "bProcessing"       : true,
            "order"             : [ [0, 'desc'] ],
            "aLengthMenu"       : [ [5, 10, 15, 20, 25, 50, 100], [5, 10, 15, 20, 25, 50, 100] ],
            'iDisplayLength'    : 10,
            "aoColumns"         : [
              {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}
            ],
            "bServerSide"       : true,
            "sAjaxSource"       : 'bank_receipt/fetch.php',
        });
    }
    
    function confirmDelete(e) {
      var $i = $(e).attr("id");
      console.log($i);
      swal({
          title: "Are you sure?",
          text: "You will not be able to recover this imaginary file!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it!",
          closeOnConfirm: false
      }, function (isConfirm) {
          if (!isConfirm) return;
          $.ajax({
              url: "bank_receipt/delete.php",
              type: "POST",
              data: 'delete='+$i,
              dataType: "json",
              success: function () {
                swal({title: "Deleted!", text: "Data successfully Deleted!", type: "success"},
                  function(){ 
                    location.reload();
                  }
                );
              },

              error: function (xhr, ajaxOptions, thrownError) {
                swal("Error deleting!", "Please try again", "error");
              }
          });
      });
    }
    function Print(e){
      var $i = $(e).attr("id");
      $.ajax({  
        url:"bank_receipt/bank_receipt_print.php",  
        method:"post",  
        data:{id:$i},  
        success:function(data){  
          $('#employee_detail').html(data);  
          $('#dataModal').modal("show");  
        }  
      });
    } 
  </script>
