<?php

class MyTime { 
    var $day;
    var $month;
    var $year;
    var $hour;
    var $minute;
    var $second;

    function get_time_for_db() {
        return $this->hour . ':' . $this->minute . ':' . $this->second;
    }

    function get_date_for_db() {
        return $this->year . '-' . $this->month . '-' . $this->day;
    }

    function get_date_time_for_db() {
        return $this->get_date_for_db() . ' ' . $this->get_time_for_db();
    }

    function get_date_time() {
        return $this->day . "-" . $this->month . "-" . $this->year . " " . $this->hour . ":" . $this->minute . ":" . $this->second;
    }
}

if (!function_exists('get_current_date_time')) { 
    function get_current_date_time() {
        date_default_timezone_set("Asia/Calcutta"); 
        $timestamp = strtotime(date('Y-m-d H:i:s'));

        $mytime = new MyTime();
        $mytime->day = date('d', $timestamp);
        $mytime->month = date('m', $timestamp);
        $mytime->year = date('Y', $timestamp);
        $mytime->hour = date('H', $timestamp);
        $mytime->minute = date('i', $timestamp);
        $mytime->second = date('s', $timestamp);
        return $mytime;
    }
}

if (!function_exists('date_diffrence')) {
    function date_diffrence($time1, $time2, $interval_required = true, $precision = 6) {
        // If not numeric then convert texts to unix timestamps
        if (!is_int($time1)) {
            $time1 = strtotime($time1);
        }

        if (!is_int($time2)) {
            $time2 = strtotime($time2);
        }

        // If time1 is bigger than time2
        // Then swap time1 and time2
        if ($time1 > $time2) {
            $ttime = $time1;
            $time1 = $time2;
            $time2 = $ttime;
        }

        // Set up intervals and diffs arrays
        $intervals = array('Year','Month','Day','Hour','Minute','Second');

        $diffs = array();

        // Loop thru all intervals
        foreach ($intervals as $interval) {
            // Create temp time from time1 and interval
            $ttime = strtotime('+1 ' . $interval, $time1);

            // Set initial values
            $add = 1;
            $looped = 0;

            // Loop until temp time is smaller than time2
            while ($time2 >= $ttime) {
                // Create new temp time from time1 and interval
                $add++;
                $ttime = strtotime("+" . $add . " " . $interval, $time1);
                $looped++;
            }

            $time1 = strtotime("+" . $looped . " " . $interval, $time1);
            $diffs[$interval] = $looped;
        }

        $count = 0;
        $times = array();

        // Loop thru all diffs
        if($interval_required){
            foreach ($diffs as $interval => $value) {
                // Break if we have needed precission
                if ($count >= $precision) {
                    break;
                }

                // Add value and interval 

                // if value is bigger than 0
                if ($value > 0) {
                    // Add s if value is not 1
                    if ($value != 1) {
                        $interval .= "s";
                    }

                    // Add value and interval to times array
                    $times[] = $value . " " . $interval;
                    $count++;
                }
            }
        } else {
            $times[] = trim($diffs['Year']);
            $times[] = trim($diffs['Month']);
            $times[] = trim($diffs['Day']);
        }

        // Return string with times
        return implode(", ", $times);
    }
}

if (!function_exists('validateDate')) {

    function validateDate($date) {

        $d = DateTime::createFromFormat('Y-m-d', $date);

        return $d && $d->format('Y-m-d') == $date;

    }
}

if (!function_exists('risFormatDate')) {
    function risFormatDate($date = '', $format = 'd-m-Y'){
        if(empty($date)){
            $date = get_current_date_time()->get_date_time_for_db();
        }

        if( $format == 'd, F Y' ) {
            $CI     = get_instance();
            $months = $CI->config->item('gu_month_names');
            return date('d', strtotime($date)) . ', ' . $months[date('m', strtotime($date))] . ' ' . date('Y', strtotime($date));
        } else {
            return date($format, strtotime($date));
        }
    }
}

if (!function_exists('getStartAndEndDate')) {
    function getStartAndEndDate($week, $year) {
        $time = strtotime("1 January $year", time());

        $day = date('w', $time);
        $time += ((7*$week)+1-$day)*24*3600;
        $return[0] = date('Y-m-d', $time);
        $time += 6*24*3600;
        $return[1] = date('Y-m-d', $time);

        return $return;
    }
}

$year  = date('y', strtotime(get_current_date_time()->get_date_for_db()));
if( strtotime( risFormatDate('', 'Y-m-d') ) <= strtotime(FINANCIAL_END_DATE) ) {
    $year = $year - 1;
}  
$finanlcial_year = $year . ($year + 1);