<?php 
$account = mysqli_query($conn, "SELECT * FROM `act_master`");
$account_data = array();
while ($account_row = mysqli_fetch_assoc($account)) {
   $account_data[] = $account_row;
}
?>
<section class="content-header">
   <div class="row">
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 bottom20">
         <h3 class="capital font15 padding5 bold">ACCOUNT LEDGER</h3>
      </div>
   </div>
</section>
<hr class="bottom35">
<section class="hitz-top-header">
   <div class="row bottom40">
      <div class="col-xs-12">
         <div class="box box-success">
            <div class="box-body">
               <div class="row">
                  <div class="col-md-2">
                     <div class="form-group">
                        <label class="capital">START DATE</label>
                        <div class="input-group">
                           <div class="input-group-addon">
                              <i class="fa fa-calendar date-icon-color"></i>
                           </div>
                           <input type="text" name="start_date" id="start_date" class="form-control date-picker" autocomplete="off" value="<?php echo risFormatDate($date);?>" tabindex="1"/>
                        </div>
                     </div>
                  </div>
                  <div class="col-md-2">
                     <div class="form-group">
                        <label class="capital">END DATE</label>
                        <div class="input-group">
                           <div class="input-group-addon">
                              <i class="fa fa-calendar date-icon-color"></i>
                           </div>
                           <input type="text" name="end_date" id="end_date" class="form-control date-picker" autocomplete="off" value="<?php echo risFormatDate($date);?>" tabindex="2">
                        </div>
                     </div>
                  </div>
                  <div class="col-md-2">
                     <div class="form-group">
                        <label class="capital">TYPE</label>
                        <select class="form-control" name="report_type" id="report_type" tabindex="3">
                           <option value="ACCOUNT">ACCOUNT</option>
                           <option value="ACCOUNT DETAILS">ACCOUNT DETAILS</option>
                        </select>
                     </div>
                  </div>
               </div>
               
               <div class="row">
                  <div class="col-md-12">
                     <div class="col-md-5" style="display: none;">
                        <table class="table table-bordered">
                           <tr>
                              <th>ACCOUNT GROUP</th>
                              <th>CLOSING BALANCE</th>
                              <th></th>
                           </tr>
                        </table>
                     </div>
                     <div class="col-md-7" id="account-name-wrapper">
                        <div class="col-md-12">
                           <select class="form-control select2" name="search_term" id="search_term">
                              <option></option>
                              <?php 
                              foreach ($account_data as $key => $account_datas) { ?>
                              <option value="<?php echo $account_datas['id']?>"><?php echo $account_datas['act_code']?> - <?php echo $account_datas['ac_name']?></option>
                              <?php } ?>
                           </select>
                        </div>
                        <div class="col-md-12">
                           <div style="width:100%; height:250px; overflow:auto;">
                              <table class="table table-bordered top10">
                                 <thead>
                                    <tr class="account-report-header">
                                       <th width="20%">ACCOUNT CODE</th>
                                       <th>ACCOUNT NAME</th>
                                       <th width="25%" class="text-right">CLOSING BALANCE</th>
                                       <th width="5%" class="text-right"></th>
                                    </tr>
                                 </thead>
                                 <tbody>
                                    <tr>
                                       <td colspan="5" class="text-center">NO DATA FOUND...!!!</td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>

               <div class="row">
                  <div class="col-md-11" id="ledger-detail-wrapper">
                     <form method="POST" id="serial_form">
                        <button type="submit" name="serial_insert" id="serial_insert" class="btn btn-primary custom-next-prev-btn capital">PRINT</button>
                        <table class="table table-bordered top10">
                           <thead>
                              <tr>
                                 <th width="100%" colspan="12">Ledger Account <span class="account_code"></span> - <span class="account_name"></span>&nbsp;&nbsp; From Date : <span class="start_date"></span> To Date <span class="end_date"></span></th>
                              </tr>
                              <tr>
                                 <th width="100%" colspan="12">Opening Balance <span>:</span> <span class="opening_balance"></span>&nbsp;<span class="op_flag"></span></th>
                              </tr>
                              <tr>
                                 <th width="100%" colspan="12">Closing Balance <span style="position: relative;left: 6px;">:</span>&nbsp; <span class="closing_balance"></span>&nbsp;<span class="cl_flag"></span></th>
                              </tr>
                              <tr class="account-report-header">
                                 <th width="5%">DATE</th>
                                 <th width="8%">VOUCHER</th>
                                 <th width="10%">TYPE</th>
                                 <th>ACCOUNT</th>
                                 <th width="8%">DEBIT</th>
                                 <th width="8%">CREDIT</th>
                                 <th width="8%">BALANCE</th>
                                 <th width="5%"></th>
                                 <th width="15%">REMARKS</th>
                                 <th width="1%"></th>
                                 <th width="5%">CL.DATE</th>
                                 <th width="1%"></th>
                              </tr>
                           </thead>
                           <tbody>
                              <tr>
                                 <td colspan="12" class="text-center">NO DATA FOUND...!!!</td>
                              </tr>
                           </tbody>
                        </table>
                     </form>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>
<script type="text/javascript">
jQuery(document).ready(function() {
   jQuery('#report_type').select2();
   jQuery('#search_term').select2();
   jQuery(document).on('focusout', "#end_date", function() {
      GetAccountname();
   });

   jQuery(document).on('change', "#search_term", function() {
      GetAccountname();
   });

   jQuery('#serial_form').on("submit", function(event) {
      event.preventDefault();
      $.ajax({
         url: "report/general_ledger/temp_ledger_entry.php",
         method: "POST",
         data: $('#serial_form').serialize(),
         dataType : 'JSON',
         beforeSend: function() {
           jQuery('#serial_insert').val("Insert");
         },
         success: function(data) {
            if(data.status = 'true') {
               exportPdf(data.account_code,data.created_id);
            }
         }
      });
   });
});

function GetAccountname(ele){
   $start_date = jQuery('#start_date').val();
   $end_date   = jQuery('#end_date').val();
   $search_term= jQuery('#search_term').val();
   $.ajax({
      type: "POST",
      url: 'report/general_ledger/fetch_account_name_closing.php',
      data: {
         'start_date' : $start_date,
         'end_date'   : $end_date,
         'search_term': $search_term
      },
      dataType : 'JSON',
      beforeSend: function() {
         jQuery('#account-name-wrapper tbody').html('<tr><td colspan="5">PLEASE WAIT...!!!</td></tr>');
      },
      success: function(data){
         if(data.tbody != '') {
            jQuery('#account-name-wrapper table tbody').html(data.tbody);
         }
      }
   });
}

function LedgerAccountDetail(e){
   var $start_date    = jQuery('#start_date').val();
   var $end_date      = jQuery('#end_date').val();
   var $report_type   = jQuery('#report_type').val();
   var $account_code  = jQuery(e).attr("id");
   $.ajax({
      type: "POST",
      url: 'report/general_ledger/account_ledger_detail.php',
      data: {
         'start_date'  : $start_date,
         'end_date'    : $end_date,
         'account_code': $account_code,
         'report_type' : $report_type
      },
      dataType : 'JSON',
      beforeSend: function() {
         jQuery('#ledger-detail-wrapper tbody').html('<tr><td colspan="12">PLEASE WAIT...!!!</td></tr>');
      },
      success: function(data){
         if(data.tbody != '') {
            jQuery('#ledger-detail-wrapper table tbody').html(data.tbody);
            jQuery('.opening_balance').html(data.opening);
            jQuery('.closing_balance').html(data.closing);  
            jQuery('.account_name').html(data.account_name);  
            jQuery('.account_code').html(data.account_code);
            jQuery('.op_flag').html(data.op_flag);
            jQuery('.cl_flag').html(data.cl_flag);
            jQuery('.start_date').html(data.start_date);
            jQuery('.end_date').html(data.end_date);  
         }
      }
   });
}

function exportPdf($code,$id) {
   var $code = $code;
   var $id   = $id;
   var url = "report/general_ledger/account_ledger_print.php?p1=" + $code;
   url += '&p2=' + $id;
   url += '&p3=' + jQuery('#start_date').val();
   url += '&p4=' + jQuery('#end_date').val();
   window.open(url, "_blank");
}
</script>