<section class="content-header">
   <div class="row">
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 bottom20">
         <h3 class="capital font15 padding5 bold">PENDING POD REGISTER</h3>
      </div>
   </div>
</section>
<hr class="bottom35">
<section class="hitz-top-header">
  <div class="row bottom40">
    <div class="col-xs-12">
      <div class="box box-success">
        <div class="box-body">
          <div class="row">
            <div class="col-md-12">
              <div class="col-md-2">
                <div class="form-group">
                  <label class="capital">START DATE</label>
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar date-icon-color"></i>
                    </div>
                    <input type="text" name="start_date" id="start_date" class="form-control date-picker" autocomplete="off" value="<?php echo risFormatDate($year);?>" tabindex="1" />
                  </div>
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group">
                  <label class="capital">END DATE</label>
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar date-icon-color"></i>
                    </div>
                    <input type="text" name="end_date" id="end_date" class="form-control date-picker" autocomplete="off" value="<?php echo risFormatDate($date);?>" tabindex="2">
                  </div>
                </div>
              </div>
              <div class="col-md-4">
                  <button type="button" class="btn btn-primary top10" id="btn-genrate">GET DATA</button>
                  <button type='submit' class="btn btn-primary top10" id="btnExport">EXCEL </button>
                  <button type='button' class="btn btn-primary top10" id="ExportPdf" target="_BLANK"> PDF</button>
              </div>
            </div>
          </div>
            <div class="row">
               <div class="col-md-12">
                  <div class="box-body table-responsive">
                    <table id="list_data" class="table table-bordered list_data">
                      <thead>
                        <tr>
                          <th class="text-center" width="5">LR NO.</th>
                          <th class="text-center" width="5">DATE</th>
                          <th class="text-center" width="8">TRUCK NO</th>
                          <th class="text-center" width="100">CONSIGNOR</th>
                          <th class="text-center" width="100">CONSIGNEE</th>
                          <th class="text-center" width="100">AGENT</th>
                          <th class="text-center" width="70">FROM</th>
                          <th class="text-center" width="70">TO</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                          <td colspan="8" class="text-center">No Data found to show !!</td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
               </div>
            </div>
        </div>
      </div>
    </div>
  </div>
</section>
<script type="text/javascript">
   jQuery(document).on('click', '#btn-genrate', function(e){
      getData();
   });

   jQuery(document).on('click', '#btnExport', function(e){
      ExportExcel();
   });

   jQuery(document).on('click', '#ExportPdf', function(e){
      exportReport();
   });

   function getData() {
      var url = "report/pending_pod_register_data.php?>" + '&start_date=' + jQuery('#start_date').val() + '&end_date=' + jQuery('#end_date').val();
      jQuery.ajax({
         type        : 'GET',
         url         :  url,
         dataType    : 'JSON',
         beforeSend:function(){
           jQuery('#list_data tbody').html('<tr><td colspan="7" class="text-center"><i class="fa fa-2x fa-spin fa-spinner"></i> Loading Data....</td></tr>');
         },
         success: function(data) {
           if(data.status == 'success') {
             if(data.tbody != '') {
               jQuery('#list_data tbody').html(data.tbody);
             } else {
               jQuery('#list_data tbody').html('<tr><td colspan="7" class="text-center">No Data found to show !!</td></tr>');
             }
           }
         }
      });
   }

   function ExportExcel(){
      jQuery("#list_data").table2excel({
         filename: "pending_pod_register.xls"
      });
   }

   function exportReport() {
      var url = "report/pending_pod_register_pdf.php?start_date=" + jQuery('#start_date').val();
      url += '&end_date=' + jQuery('#end_date').val();
      window.open(url, "_blank");
   }
</script>
